/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.udp;

import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.udp.DatagramSocketListener;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.fcs.impl.udp.NotificationQueue;
import com.ibm.hwmca.fw.fcs.impl.udp.OutgoingDatagramPortOwner;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;

public class IncomingDatagramPortOwner {
    private static final String TRACE_MASKD = "XFCSIDPD";
    private static final String TRACE_MASKF = "XFCSIDPF";
    private static final String TRACE_MASKT = "XFCSIDPT";
    private static IncomingDatagramPortOwner _singleton;
    private static boolean useMulticast;
    private static DatagramSocket inSocket;
    private static DatagramSocketListener[] socketListeners;
    private static NotificationQueue datagramQueue;
    private boolean useTestCode = false;
    private static MachineId machineId;

    private IncomingDatagramPortOwner() {
        datagramQueue = new NotificationQueue();
        this.buildSocket();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void buildSocket() {
        boolean deprecated = true;
        if (deprecated) {
            return;
        }
        if (this.useTestCode) {
            try {
                int i;
                if (socketListeners != null) {
                    for (i = 0; i < socketListeners.length; ++i) {
                        socketListeners[i].closeSocket();
                    }
                }
                if (machineId == null) return;
                socketListeners = new DatagramSocketListener[machineId.getNicAddresses().length];
                for (i = 0; i < socketListeners.length; ++i) {
                    if (useMulticast) {
                        MulticastSocket tmpSocket = new MulticastSocket(9900);
                        tmpSocket.joinGroup(InetAddress.getByName("225.4.5.6"));
                        tmpSocket.setInterface(machineId.getNicAddresses()[i]);
                        IncomingDatagramPortOwner.socketListeners[i] = new DatagramSocketListener(tmpSocket, datagramQueue);
                    } else {
                        IncomingDatagramPortOwner.socketListeners[i] = new DatagramSocketListener(new DatagramSocket(9900, machineId.getNicAddresses()[i]), datagramQueue);
                    }
                    socketListeners[i].start();
                }
                return;
            }
            catch (SocketException se) {
                Trace.trace(TRACE_MASKF, se);
                socketListeners = null;
                return;
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, ioe);
                socketListeners = null;
                return;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                socketListeners = null;
                return;
            }
        }
        try {
            if (inSocket != null) {
                inSocket.close();
            }
            if (useMulticast) {
                inSocket = new MulticastSocket(9900);
                ((MulticastSocket)inSocket).joinGroup(InetAddress.getByName("225.4.5.6"));
                ((MulticastSocket)inSocket).setInterface(InetAddress.getLocalHost());
                return;
            } else {
                inSocket = new DatagramSocket(9900);
            }
            return;
        }
        catch (SocketException se) {
            inSocket = null;
            return;
        }
        catch (IOException ioe) {
            inSocket = null;
        }
    }

    public void closeSocket() {
        if (this.useTestCode) {
            if (socketListeners != null) {
                for (int i = 0; i < socketListeners.length; ++i) {
                    if (socketListeners[i] == null) continue;
                    try {
                        socketListeners[i].closeSocket();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                socketListeners = null;
            }
        } else if (inSocket != null) {
            try {
                inSocket.close();
                inSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static synchronized IncomingDatagramPortOwner getIncomingDatagramPortOwner() {
        if (_singleton == null) {
            _singleton = new IncomingDatagramPortOwner();
        }
        return _singleton;
    }

    public static void setUseMulticast(boolean value) {
        if (useMulticast != value) {
            useMulticast = value;
            IncomingDatagramPortOwner.getIncomingDatagramPortOwner().buildSocket();
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner().closeSocket();
            OutgoingDatagramPortOwner.getOutgoingDatagramPortOwner();
        }
    }

    public static boolean isUseMulticast() {
        return useMulticast;
    }

    public DatagramPacket receive() {
        if (this.useTestCode) {
            Object inPacket = null;
            if (socketListeners == null) {
                this.buildSocket();
            }
            if (socketListeners != null) {
                DatagramPacket fcsDatagram = (DatagramPacket)datagramQueue.readItem();
                return fcsDatagram;
            }
            return null;
        }
        DatagramPacket inPacket = null;
        if (inSocket == null) {
            this.buildSocket();
        }
        if (inSocket != null) {
            byte[] buffer = new byte[504];
            inPacket = new DatagramPacket(buffer, buffer.length);
            try {
                inSocket.receive(inPacket);
                FcsDatagram datagram = new FcsDatagram(inPacket);
            }
            catch (FcsException fcse) {
                inPacket = null;
            }
            catch (IOException ioe) {
                inPacket = null;
            }
            catch (Exception e) {
                inPacket = null;
            }
        }
        return inPacket;
    }

    public void networkSettingsChanged() {
        this.closeSocket();
        this.buildSocket();
        MachineId tmp = null;
        try {
            tmp = FcsServer.getFcsServer().getLocalMachineId();
            if (tmp != null) {
                machineId = tmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restart() {
        if (this.useTestCode) {
            if (socketListeners == null) {
                this.buildSocket();
            }
        } else if (inSocket == null) {
            this.buildSocket();
        }
    }

    public static void setMachineId(MachineId newMachineId) {
        machineId = newMachineId;
    }

    static {
        useMulticast = false;
    }
}

